% ANH NGUYEN (2013)- Lancaster University
% This code is written based on the guidance from "Beyond the Kalman
% Filter"

function ind= resamplesys(w,N,ran1)
%N: no of particles
%x: a vector state variables
%w: probability vector
%xr- x resampled
%wr- weight resampled
%ind- parent
% The dimension of the matrix xor is: "l*N"
ind=zeros(1,N);
c=zeros(N,1);
%xr=zeros(N,d);
%d- is dimension of state vector

%% (1) Initialize the Cumulative sum of weights
c(1)=w(1);

%% (2) Construct CSW
for i=2:N;

    c(i)=c(i-1)+w(i);
end

%% (3) Start at the bottom of the CSW
i=1;

%% (4) Draw a starting point
%Generate values from the uniform distribution on the interval [a, b]:
%r = a + (b-a).*rand(100,1);
% u1 -- U[0,1/N]
u=zeros(N,1);
%u(1)=(1/N)*rand(1);
u(1)=(1/N)*ran1;

%% (5) Move along CSW
for j=1:N;
    u(j)=u(1)+1/N*(j-1);
    while u(j)>c(i);
        i=i+1;
    end
    
%% (6) Assign values   
% Assign sample
ind(j)=i;
%Assign weight
% wr(j)=1/N;
%Assign parent;
%ind(j)=i;
end







    
 